#include "vars.h"
#include "hscore.h"
#include <string.h>

HIGH_SCORE_ENTRY* load_scores(char* path, int* nb_high_score_entries) {
   HIGH_SCORE_ENTRY* hi_score;
   PACKFILE* f;
   int i;

   f = pack_fopen(path, F_READ_PACKED);
   
   if (f == NULL) {
      fprintf(fp, "Unable to read the file \"%s\"!\nCreating an empty table...\n", path);

      hi_score = create_empty_score_table(SIZE_HIGH_SCORE_TABLE);
      
      if (!hi_score)
         fprintf(fp, "Internal error: mem error!\n");
      else 
         fprintf(fp, "Done!\n");
      return hi_score;
   }

   fprintf(fp, "Reading high score table...");

	//on récupère le nombre d'entrées
	pack_fread(nb_high_score_entries, sizeof(int), f);

   //astuce, on en cre une vierge que l'on remplie petit  petit!
   hi_score = create_empty_score_table(*nb_high_score_entries);

   for (i = 0; i < SIZE_HIGH_SCORE_TABLE; ++i) {
      pack_fread(&hi_score[i], sizeof(HIGH_SCORE_ENTRY), f);
   }
   
   pack_fclose(f);
   fprintf(fp, "Done!\n");
   return hi_score;
}
/*
int get_pack_string(char* str, PACKFILE* f) {
   int i, c;
   
   i = 0;
   while ((c = pack_getc(f)) != '\0' && i < MAX_NAME_LENGTH)
      str[i++] = c;
   
   return i;
} */ 



HIGH_SCORE_ENTRY* create_empty_score_table(int size_score_table) {
   int i;
   HIGH_SCORE_ENTRY* new_table;
  
   new_table = malloc(size_score_table*sizeof(HIGH_SCORE_ENTRY));
   if (new_table == NULL) {
      fprintf(fp, "Mem error : table\n");
      return NULL;
   }
   
   for (i = 0; i < size_score_table; ++i) {
      strcpy(new_table[i].name, "Default\0");
      new_table[i].score = 0;
   }

   return new_table;
}

//on vrifie si les scores du joueur sont dans la table
//RETOURS
//TRUE : Ils y sont
//FALSE : Trop mauvais, ils n'y sont pas!
int check_scores(HIGH_SCORE_ENTRY* score_table, int size_score_table, int score) {
   int i;

   for (i = 0; i < size_score_table; ++i) {
      //les scores doivent tre dans l'ordre du meilleur au plus mauvais
      if (score_table[i].score < score)
         return i;
   }
   return -1;
}

void change_score_name(HIGH_SCORE_ENTRY *score_table, char *name, int pos) {
   strcpy(score_table[pos].name, name);
   return;
}
   
   
   
//Fonction qui rajoute le nom et le score dans la table!
//elle "pousse" les scores infrieurs
void update_scores(HIGH_SCORE_ENTRY *score_table, int score_table_size, char *name, int score) {
   int i, j;
   
   for (i = 0; i < score_table_size; ++i) {
      if (score_table[i].score >= score)
         continue;

      //maintenant, on doit l'insrer
      j = score_table_size-1;
      while (j != i) {
         score_table[j] = score_table[j-1];
         --j;
      }
      score_table[i].score = score;
      strcpy(score_table[i].name, name);
      return;
   }
   return;
}

void save_scores(HIGH_SCORE_ENTRY* hi_score, char* path, int score_table_size) {
   PACKFILE* f;
   int i;
   
   f = pack_fopen(path, F_WRITE_PACKED);

   if (!f) {
      fprintf(fp, "Error : Unable to create \"%s\"!\n", path);
      return;
   }      
   
   fprintf(fp, "Writing...\n");
  
   pack_fwrite(&score_table_size, sizeof(int), f);
   for (i = 0; i < score_table_size; ++i) {
      pack_fwrite(&hi_score[i], sizeof(HIGH_SCORE_ENTRY), f);
      fprintf(fp, "Name = %s Score = %ld\n", hi_score[i].name, hi_score[i].score);
   }
   pack_fclose(f);
   return;
}

  
      
   
